
s        x   # q2  p                                            eip123x     EIP 1230A/1231A VXIbus Frequency Counter      -     Instrument Name: EIP123xA Pulsed Microwave
                  Frequency Counter

 Description:     This instrument module provides
                  programming support for the
                  EIP1230A and EIP1231A Microwave
                  Frequency counters. The module
                  is divided into the following
                  Classes:

 Functions/Classes:

 (1) Initialize
     Initialize the instrument and set to default
     configuration.

 (2) Configuration
     This class contains the functions required to
     configure the instrument.

     (2a) Bands (EIP1230A & EIP1231A)
          This sub-class contains the band
          configuration functions for both
          instruments. It also contains the
          Frequency Windows function which may
          only be used with Band 2, and the
          Center Frequency Function which is
          available for Bands 2 & 3.

 (3)  Special Functions
      This class contains the Special Functions
      which this instrument driver supports.

 (4)  Measurement Functions
      This class contains the functions necessary
      to capture and display measurements.

 (5)  Save and Recall Instrument Setup
      This class contains functions that store and
      recall the current instrument setup

 (6)  Close
      Take the instrument offline.         Class Name:    Configuration

 Description:   This class contains functions to
                configure the output of the
                instrument.

 Functions/Class:

 (1)  Bands (EIP1230A & EIP1231A):
      This sub-class contains the band
      configuration functions for both
      instruments. It also contains the Frequency
      Windows function which may only be used with
      Band 2, and the Center Frequency Function
      which is available for Bands 2 & 3.

 (2)  Sample Rate:
      This function sets a delay between
      measurement values (0 to 100 seconds 10 mS
      resolution)

 (3)  Resolution:
      This function controls the frequency
      measurement resolution. Select the desired
      resolution according to the following table:

      Resolution    Freq        Gate Time

          2         100 Hz      10 ms
                                (Band 0 only)
          3         1 kHz       1 ms
          4         10 kHz      100 ys
          5         100 kHz     10 ys
          6         1 MHz       1ys
          7         10 MHz      1ys
          8         100 MHz     1ys
          9         1 GHz       1ys

 (4)  Frequency Average:
      This function controls the number of
      measurements to be averaged on frequency and
      pulse measurements. Select in the range of
      1 to 99.

 (5)  This function allows the entry of a positive
      or negative frequency to 1 kHz resolution
      into the offset frequency register. This
      parameter controls the contant B in the
      formula:
      Output Freq = ( M * measured freq) + B where
      M is the frequency multiplier and B is the
      frequency offset. Select in the range
      -99.99 999 GHz to + 99.99 999 GHz.

 (6)  Min Pulse Repetition:
      This function controls the minimum pulse
      repetition frequency of the pulsed signals
      that can be acquired and measured by the
      counter. For example if a MINPRF of 500 Hz
      is selected, the counter will only measure
      signals with a pulse repetition frequency of
      500 Hz or greater.

 (7)  Inhibit Input:
      This function selects the input to be used
      for the inhibit measurement function.
      Arguments 0, 1, and 2 correspond to the
      VXIbus ECLTRG0 line, VXIbus ECLTRG1 line,
      and front panel, respectively. Note that
      inhibit is active high(i.e., the counter is
      inhibited by a logic high signal and enabled
      by a logic low signal).

 (8)  Trigger Setup:
      This function configures the INT/EXT time
      base reference. Selects the TTLTRG line pair
      to be used in the Asynchronous Trigger
      Protocol. The valid range is 0 to 3,
      corresponding to TTLTRG pairs 0 & 1, 2 & 3,
      4 & 5, and 6 & 7 respectively. Issuing
      ASYNC 9 disables the protocol. Selects the
      TTLTRG line to be used in the Synchronous
      Trigger Protocol. the valid range is 0 to 7.
      Issuing SYNC 9 disables the protocol.
    
     Class Name:    Bands (1230 A & 1231 A)

 Description:   This class contains functions to
                configure input bands 0, 1, 2, & 3
                of the instrument, and functions
                whose scope is limited to bands 2
                & 3 only.

 Functions:

 (1)  Bands for 1230 A
      This function contains the band
      configuration functions for the EIP1230A

 (2)  Bands for 1231 A
      This function contains the band
      configuration functions for the EIP1231A

 (3)  Center Frequency
      This function controls the center frequency
      mode of operation in which the counter looks
      for a signal in the vicinity of the center
      frequency value. This mode can be used to
      reduce acquisition time or when measuring a
      particular signal in a multiple signal
      environment. This mode of operation is
      available in Bands 2 and 3 only. Select Band
      2 center frequency in the range of 900 MHz
      to 26.7 GHz for the model 1230A, and in the
      range of 900 MHz to 20.5 GHz for the model
      1230A. The counter will lock on signals
      50 MHz from the entered center frequency.
      Select Band 3 center frequency in the range
      of the subband currently selected. The
      counter will lock on to signals 2 GHz from
      the entered frequency, but will not reject
      signals outside of this range. If a signal
      is applied that is more than 2 GHz from the
      entered frequency an erroneous reading may
      result. The value entered by the user is
      truncated to 10 MHz.

 (4)  Frequency Window Limits
      This function controls the high and low
      limits of the frequency window that is
      searched in Band 2. Select Low and High
      Limit in the range of 900 MHz to 26.7 GHz
      for the model 1230A, and in the range of
      900 MHz to 20.5 GHz for the model 1230A.
      The value entered by the user is truncated
      to 10 MHz resolution. This function is only
      available in Band 2, and Low limit must
      always be less than High limit.    s     Class Name:    Special Functions

 Description:   This class contains functions
                which enhance the basic
                capabilities of the EIP 1230A &
                1231A counters.

 Functions:

 (1)  Special Functions
      This function selects the special function
      from the special functions which this driver
      supports.  Call the Terminate All Specials
      function before using this function to
      insure the instrument is in the proper state
      to use this function.

 (2)  Terminate All Specials
      This Function terminates all previously
      implemented special functions.
         Class Name:    Measurement

 Description:   This class contains functions to
                obtain measurements from the
                instrument.

 Functions:

 (1)  Hold Function:
      This function holds the the last result if
      on. Hold On puts the instrument into a
      triggered operational mode.

 (2)  Set Measurement Type:
      This function selects which type of
      measurement will be taken, Frequency, Width,
      or Period. This function must be called
      before the Get Measurement function is
      called, and before the trigger is used if a
      triggered mode is selected.

 (3)  Trigger Function:
      This function selects and implements one of
      the two internal trigger functions, trigger
      or reset. Trigger triggers a new measurement
      cycle. If a measurement cycle is in progress
      it will be aborted. Reset resets the
      converter and restarts the measurement
      process. If a measurement is found, a
      measurement will be taken, even if the
      counter is in Hold.

 (4)  Get Measurement:
      Reads the measurement back from the
      instrument. All measurement configuration
      and triggering must be implemented before
      this function is called to insure accurate
      data is returned from the instrument.         Class Name:    Save/Recall Instr Setup

 Description:   This Class saves and recalls
                instrument set up configuration
                information from the instrument
                storage registers.

 Functions:
 (1)  Save/Recall Instr Setup:
      This function selects and implements the
      Store or Recall functions. If Store is
      selected the instrument will store the
      current counter setup in one of its 10
      internal storage registers.
 (2)  Save Default Setup:
      Restores save/recall setup register 0 to
      the factory default settings.
 (3)  Get General Setup Info:
      This function displays the current status of
      the parameter selected.    F     Class Name:    Low Level Functions

 Description:   Provides lower level functions to
                communicate with the instrument,
                and change instrument parameters.

 Functions:

 (1) Write To Instrument:
     Writes commands and queries to the instrument
     to modify parameters and query device
     settings.

 (2) Read Instrument Data:
     Reads data from instrument buffer and returns
     it to the specified variable in memory.

 (3) Reset:
     This function resets the instrument to its
     default state.

 (4) Error Clear/Query:
     This function can be used to either command
     the instrument to clear its error condition
     flags, or read its current error code.

 (5) Revision Query:
     This function returns the revision numbers of
     the instrument driver and instrument
     firmware.         Panel Name:    Initialize

 Description:   This routine performs the
                following initialization actions:

                -  Opens the instrument by
                   storing information about the
                   instrument in the Instrument
                   Table.

                -  Initializes the VXI interface
                   (NI-VXI or NI-GPIB)
                   accordingly.

                -  Performs an identification
                   query on the Instrument to
                   determine the model number.

                -  Sends initialization commands
                   to the instrument.

                -  Returns an Instrument ID which
                   is used to differentiate
                   between instruments of the same
                   model type.  This value will be
                   used to identify the instrument
                   in subsequent calls.    =     Control Name:  Logical Address

 Description:   Specifies the Logical Address of
                the VXI instrument.  This value
                must corrrespond to the current
                internal setting of the
                instrument.

 Variable Type: Integer

 Valid Range:   0 - 255

 Default Value: 18         Control Name:  Interface

 Description:   Specifies which protocol is used
                to communicate with the VXI
                mainframe.

                NI-VXI should be selected for
                MC-MXI, AT-MXI, or VXIpc-386.

                NI-GPIB should be selected for the
                GPIB-VXI.

 Variable Type: Integer

 Valid Range:   1 - NI VXI
                2 - NI GPIB

 Default Value: 1 - NI VXI         Control Name:  ID Query

 Description:   Specifies if an ID Query is sent
                to the instrument during the
                initialization procedure.

 Variable Type: Integer

 Valid Range:   1 - Do Query
                0 - Skip Query

 Default Value: 1 - Do Query

 NOTE:  Under normal circumstances the ID Query
        insures that the instrument initialized
        is the type supported by this driver.
        However circumstances may arise where it
        is undesirable to send an ID Query to the
        instrument.  In those cases; set this
        control to "Skip Query" and this function
        will initialize the selected interface and
        the command arrays in the driver, without
        doing an ID Query.         Control Name:  Reset Device

 Description:   Specifies if the instrument is to
                be reset to its power-on settings
                during the initialization
                procedure.

 Variable Type: Integer

 Valid Range:   1 - Reset Device
                0 - Don't Reset

 Default Value: 1 - Reset Device

 NOTE: If you do not want the instrument reset.
       Set this control to "Don't Reset" while
       initializing the instrument.    0     Control Name:  Instrument ID

 Description:   Returns an Instrument ID that is
                used in all subsequent function
                calls to select the instrument at
                the address specified.

                If more than one instrument of the
                same model type is used, this ID
                will be used to differentiate
                between them. The first instrument
                of this model type initialized
                will be assigned an Instrument ID
                of 1.

 Variable Type: Integer    D     Control Name:  Model Number

 Description:   Returns the instrument model
                number. If the user opted to
                skip the ID query, the instrument
                is assumed to be a 1230,
                otherwise the value is determined
                from the instrument.

 Variable Type: Integer         Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Logical Address out of range
       -2   Interface out of range
       -3   ID Query out of range
       -4   Reset Device out of range

      220   Unable to open instrument
      221   Unable to close instrument
      222   Unable to initialize VXI library
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      239   Error setting time out
      241   Error configuring repeat addressing    * M (           Logical Address                   + M           Interface                         - M          ID Query                          0 M          Reset Device                      2f            Instrument ID                     4 @          Model Number                      5          Error Code                        !                                            18   NI-VXI 1 NI-GPIB 2   Do Query 1 Skip Query 0   Reset Device 1 Don't Reset 0    	            	            	            GCopyright 1994 National Instruments Corporation.  All Rights Reserved.         Panel Name:    Bands for EIP1230 A

 Description:   This function contains the band
                configuration functions for the
                EIP1230A         Control Name:  Primary Band (EIP 1230A)

 Description:   This parameter controls the
                frequency measurement range for
                the EIP1230A model.
                Select a specific band according
                to the following table.

                0: 100 Hz - 250 MHz (CW only)
                1: 250 MHz - 1 GHz
                2: 950 MHz - 26.5 GHz
                3: 26.5 GHz - 170 GHz (Optional)

 Variable Type: Integer

 Valid Range:   0 - 100 Hz - 250 MHz (CW only)
                1 - 250 MHz - 1 GHz
                2 - 950 MHz - 26.5 GHz
                3 - 26.5 GHz - 170 GHz (Optional)

 Default Value: 2 - 950 MHz - 26.5 GHz         Control Name:  Sub Band (FOR BAND 3 ONLY)

 Description:   This parameter controls the
                frequency measurement range of
                Band 3 and is set according to the
                remote sensor being used.  Select
                the appropriate subband according
                to the following table.

                1:  26.5 to 40 GHz
                2:  33 to 50 GHz
                3:  40 to 60 GHz
                4:  50 to 75 GHz
                5:  60 to 90 GHz
                6:  75 to 110 GHz
                7:  90 to 140 GHz
                8:  110 to 170 GHz

 Variable Type: Integer

 Valid Range:   1 -  26.5 to 40 GHz
                2 -  33 to 50 GHz
                3 -  40 to 60 GHz
                4 -  50 to 75 GHz
                5 -  60 to 90 GHz
                6 -  75 to 110 GHz
                7 -  90 to 140 GHz
                8 -  110 to 170 GHz

 Default Value: 1    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    c     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Primary Band out of range
       -3   Sub Band out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized

      330   Sub Band parameter valid only
            for the optional Band 26.5 - 170 GHz
            Set Sub Band back to default 26.5 -
            40 GHz

      350   This Panel valid only for EIP 1230A    < <           Primary Band                      > ={          Sub Band (GHz)                    B`             Instrument ID                     D          Error Code                       X                                           8 '                                          I                                           8                                           H                                           X                                           6                                          F                                          V                                          h                                           h                                           f                                          v                                                                                                                                                                                    /250 MHz - 0 1 GHz - 1 26.5 GHz - 2 170 GHz - 3               f26.5 - 40 - 1 33 - 50 - 2 40 - 60 - 3 50 - 75 - 4 60 - 90 - 5 75 - 110 - 6 90 - 140 - 7 110 - 170 - 8    1    	            
950 MHz -    	100 Hz -    
250 MHz -    	- Band 0    	- Band 1    	- Band 2    - SubBand 1    - SubBand 2    - SubBand 3    26.5 GHz -    	- Band 3    - SubBand 4    - SubBand 5    - SubBand 6    - SubBand 7    - SubBand 8         Panel Name:    Bands for EIP1231 A

 Description:   This function contains the band
                configuration functions for the
                EIP1231A         Control Name:  Band (EIP 1231A)

 Description:   This parameter controls the
                frequency measurement range
                for the EIP 1231A model.
                Select a specific band according
                to the following table.

                0: 100 Hz - 250 MHz (CW only)
                1: 250 MHz - 1 GHz
                2: 950 MHz - 20 GHz

 Variable Type: Integer

 Valid Range:   0 - 100 Hz - 250 MHz (CW only)
                1 - 250 MHz - 1 GHz
                2 - 950 MHz - 20 GHz

 Default Value: 2    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Band out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized

      360   This Panel Valid only for EIP 1231A    M~ =*          Band (EIP 1231A)                  O             Instrument ID                     Q          Error Code                       8                                           H                                           X                                           8@                                          H@                                          X@                                                      !250 MHz - 0 1 GHz - 1 20 GHz - 2    1    	            
100  Hz -    
250 MHz -    
950 MHz -    	- Band 0    	- Band 1    	- Band 2        Panel Name:    Center Frequency

 Description:   Controls the center frequency mode
                This function controls the center
                frequency mode of operation in
                which the counter looks for a
                signal in the vicinity of the
                center frequency value. This mode
                can be used to reduce acquisition
                time or when measuring a
                particular signal in a multiple
                signal environment. This mode of
                operation is available in Bands 2
                and 3 only. Select Band 2 center
                frequency in the range of 900 MHz
                to 26.7 GHz for the model 1230A,
                and in the range of 900 MHz to
                20.5 GHz for the model 1231A. The
                counter will lock on signals
                50 MHz from the entered center
                frequency. Select Band 3 center
                frequency in the range of the
                subband currently selected. The
                counter will lock on to signals
                2 GHz from the entered frequency,
                but will not reject signals
                outside of this range. If a signal
                is applied that is more than 2 GHz
                from the entered frequency an
                erroneous reading may result. The
                value entered by the user is
                truncated to 10 MHz.
         Control Name:  Center Frequency

 Description:   This parameter controls the center
                frequency mode of operation in
                which the counter looks for a
                signal in the vicinity of the
                center frequency value.  This mode
                can be used to reduce acquisiton
                time when measuring a particular
                signal in a multiple signal
                environment.  This mode is
                available in either Band 2 or
                Band 3.

 Variable Type: Real

 Valid Range:   Dependent upon the selected band -
                See below.

         - Band 2: 900 MHz - 26,700 MHz (EIP1230A)
                   900 MHz - 20,500 MHz (EIP1231A)

         - Band 3: The range of the Sub Band
                     currently selected:

        Subband 1:  26,500 MHz to 40,000 MHz
        Subband 2:  33,000 MHz to 50,000 MHz
        Subband 3:  40,000 MHz to 60,000 MHz
        Subband 4:  50,000 MHz to 75,000 MHz
        Subband 5:  60,000 MHz to 90,000 MHz
        Subband 6:  75,000 MHz to 110,000 MHz
        Subband 7:  90,000 MHz to 140,000 MHz
        Subband 8:  110,000 MHz to 170,000 MHz


 Default Value: 900    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Center Frequency out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      340   Function valid only for bands 2 & 3
            in the EIP 1230 A, and band 2 in EIP
            1231 A.    [ =          Center Freq (MHz)                 `s             Instrument ID                     b          Error Code                         900    1    	                Panel Name:    Frequency Window Limits

 Description:   This function controls the high
                and low limits of the frequency
                window that is searched in Band 2.
                Select Low and High Limit in the
                range of 900 MHz to 26.7 GHz for
                the model 1230A, and in the range
                of 900 MHz to 20.5 GHz for the
                model 1230A. The value entered by
                the user is truncated to 10 MHz
                resolution. This function is only
                available in Band 2, and Low limit
                must always be less than High
                limit.         Control Name:   Low Limit

 Description:   This parameter controls the low
                end of the frequency window that
                is searched for a signal in Band
                2.  Select Low Limit in the
                range of 900 MHz to 26700 MHz for
                Model 1230A and in the range of
                900 MHz to 20500 MHz for Model
                1231A.

                The value entered by the user is
                trincated to 10 MHz resolution.
                This function is only available
                in Band 2.  Low Limit must always
                be lower than High Limit.

 Variable Type: Real

 Default Value: 900 MHz
    A     Control Name:  High Limit

 Description:   This parameter controls the high
                end of the frequency window that
                is searched for a signal in Band
                2.  Select the High Limit in the
                range of 900 MHz to 26,700 MHz for
                Model 1230A and in the range of
                900 MHz to 20,500 MHz for Model
                1231A.

                The value entered by the user is
                trincated to 10 MHz resolution.
                This function is only available
                in band 2.  Low Limit must always
                be lower than High Limit.

 Variable Type: Real

 Default Value: 26,700 MHz for EIP 1230A

 - This is the value that the control is set to if
   you are using a 1231A change the default
   setting to: 20,500 MHz for EIP 1231A    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Low Limit out of range
       -3   High Limit out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      380   This panel vaid only for Band 2.    h3 = u         Low Limit (MHz)                   j =9         High Limit (MHz)                  n%             Instrument ID                     pm          Error Code                         900    26700    1    	                Panel Name:    Sample Rate

 Description:   This function sets a delay between
                measurement values (0 to 100 S
                to a 10 mS resolution).  Signal
                tracking is performed before each
                measurement.  This process adds
                approximately 100 ms to the delay
                between.  This means that even if
                the Sample Rate is set to 0 there
                will still be a 100 ms delay
                between measurements.

          Control Name:  Sample Rate

 Description:   Sets a delay between measurement
                values

 Variable Type: Long

 Valid Range:   0 to 100,000 ms, by 10 ms
                resolution

 Default Value: 0 ms (maximum sampling rate)    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    p     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Sample Rate out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized    ub =          Sample Rate (mSec)                vZ             Instrument ID                     x          Error Code                         0    1    	           \     Panel Name:    Resolution

 Description:   This function controls the
                frequency measurement resolution.
                Select the desired resolution
                according to the following table:

      Resolution    Freq        Gate Time

          2         100 Hz      10 ms
                                (Band 0 only)
          3         1 kHz       1 ms
          4         10 kHz      100 ys
          5         100 kHz     10 ys
          6         1 MHz       1ys
          7         10 MHz      1ys
          8         100 MHz     1ys
          9         1 GHz       1ys    m     Control Name:  Resolution

 Description:   This parameter controls the
                frequency measurement resolution.
                Select the desired resolution
                according to the following table:

      Resolution    Freq        Gate Time

          2         100 Hz      10 ms
                                (Band 0 only)
          3         1 kHz       1 ms
          4         10 kHz      100 us
          5         100 kHz     10 us
          6         1 MHz       1 us
          7         10 MHz      1 us
          8         100 MHz     1 us
          9         1 GHz       1 us

 Variable Type: Integer

 Valid Range:   2 - 100 Hz
                3 - 1 kHz
                4 - 10 kHz
                5 - 100 kHz
                6 - 1 MHz
                7 - 10 MHz
                8 - 100 MHz
                9 - 1 GHz

 Default Value: 3 - 1 kHz    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    o     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Resolution out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized    }3 =#          Resolution                                     Instrument ID                               Error Code                                   W100 Hz - 2 1 kHz - 3 10 KHz - 4 100 KHz - 5 1 MHz - 6 10 MHz - 7 100 MHz - 8 1 GHz - 9    1    	                 Panel Name:    Frequency Average

 Description:   This function controls the number
                of measurements to be averaged on
                frequency and pulse measurements.
                Select in the range of 1 to 99.    {     Control Name:  Frequency Average

 Description:   This parameter controls the number
                of measurements to be averaged on
                frequency and pulse parameters.
                Frequency averaging is typically
                used to reduce random measurement
                error.

 Variable Type: Integer

 Valid Range:   01  to 99

 Default Value: 01    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    v     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Frequency Average out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized    o =           Frequency Average                              Instrument ID                     :          Error Code                         01    1    	           q     Panel Name:    Frequency Offset

 Description:   Configures frequency measurement
                parameters. This function allows
                the entry of a positive or
                negative frequency to 1 kHz
                resolution into the offset
                frequency register. This parameter
                controls the contant B in the
                formula: Output Freq
                = (M * measured freq) + B where M
                is the frequency multiplier and B
                is the frequency offset. Select in
                the range -99.99  999 GHz to
                +99.99 999 GHz.         Control Name:  Multiplier

 Description:   This parameter controls the value
                of the constant M in the formula:

                Output Frequency = (M * measured
                frequency) + B

                Where M is the frequency
                multiplier and B is the frequency
                offset.

 Variable Type: Integer

 Valid Range:   1 to 99

 Default Value: 1    I     Control Name:  Offset Frequency

 Description:   Allows the entry of a positive or
                negative frequency to 1 kHz
                resolution into the offset
                frequency register.  This
                parameter controls the constant B
                in the formula:

                Output Frequency = (M * measured
                frequency) + B

                Where M is the frequency
                multiplier and B is the frequency
                offset.

 Variable Type: real

 Valid Range:   -99.99 999 GHz to +99.999 999 GHz

 Default Value: 0    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Frequency Multiplier out of range
       -3   Frequency Offset out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized     = u          Freq Multiplier                   z =9         Freq Offset  (GHz)                             Instrument ID                               Error Code                         1    0    1    	                Panel Name:    Min Pulse Repetition:

 Description:   This function controls the minimum
                pulse repetition frequency of the
                pulsed signals that can be
                acquired and measured by the
                counter. For example if a MINPRF
                of 500 Hz is selected, the counter
                will only measure signals with a
                pulse repetition frequency of
                500 Hz or greater.         Control Name:  Min Pulse Repetition

 Description:   This parameter controls the
                minimum pulse repetition frequency
                of the pulsed signals that can be
                acquired and measured by the
                counter.  For example, if 500 Hz
                is selected, the counter will
                measure signals with a pulse
                repetition frequency of 500 Hz or
                greater.

                This parameter affects the
                acquisition speed indirectly via
                two internal processes: the
                waiting time for a pulse at each
                frequency step in the frequency
                range being searched, and the
                waiting time for a pulse when
                taking measurements before
                declaring a "signal lost"
                condition.

                When Min Pulse Repetition
                is set to a low value either
                center frequency of frequency
                limits to minimize signal
                aquisition time.


 Variable Type: Real

 Valid Range:   1.0 Hz to 2.0 kHz

 Default Value: 2.0 kHz    +     Control Name:  Minimum PRF Units

 Description:   Selects the units for the
                Minimum Pulse Repetition Frequency
                specified by the Min PRF control.

 Valid Range:   0 - Hz
                1 - kHz
                2 - MHz
                3 - GHz

 Default Value: 0 - Hz    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Min Pulse Rep Freq out of range
       -3   MinPRF Units out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized     = u         Min Pulse Rep Freq                 =l          MinPRF Units                      Q             Instrument ID                               Error Code                         2.0              Hz - 0 kHz - 1 MHz - 2 GHz - 3    1    	                Panel Name:    Inhibit Input

 Description:   This function selects the source
                of the signal controlling when the
                counter can detected a signal.

                This feature allows the counter
                to perform frequency measurements
                at specific points in time.

                Arguments 0, 1, and 2 correspond
                to the VXIbus ECLTRG0 line, VXIbus
                ECLTRG1 line, and front panel,
                respectively.

                Note: The Inhibit Input is active
                high (i.e., the counter is
                inhibited by a logic high signal
                and enabled by a logic low
                signal).    /     Control Name:  Inhibit Input

 Description:   Selects the input to be used for
                the measurement inhibit function.

 Variable Type: Integer

 Valid Range:   0 - VXIbus ECLTRG0 line
                1 - VXIbus ECLTRG1 line
                2 - Front Panel


 Default Value: 2 - Front Panel    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    r     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Inhibit Input out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized    ' =/          Inhibit Input Source              ^             Instrument ID                               Error Code                                   -VXI ECLTRG0- 0 VXI ECLTRG1- 1 Front Panel- 2    1    	                 Panel Name:    Time Base Source

 Description:   This function selects the source
                of the 10 MHz frequency reference
                signal.         Control Name:  Time Base Source

 Description:   Controls the source of the
                10 MHz frequency reference
                signal.


 Variable Type: Integer

 Valid Range:   0 - Internal
                1 - External

 Default Value: 0 - Internal    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    u     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Time Base Source out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized     =           Time Base Source                               Instrument ID                               Error Code                         External 1 Internal 0    1    	                Panel Name:    Trigger Set Up

 Description:   This function selects the
                triggering mode, configures
                the INT/EXT time base reference,
                and selects the TTLTRG line pair
                to be used in the Asynchronous
                Trigger Protocol. The valid range
                is 0 to 3, corresponding to TTLTRG
                pairs 0 & 1, 2 & 3, 4 & 5, and
                6 & 7 respectively. Issuing
                ASYNC 9 disables the protocol.
                Or it selects the TTLTRG line
                to be used in the Synchronous
                Trigger Protocol. the valid range
                is 0 to 7. Issuing SYNC 9 disables
                the protocol.    :     Control Name:  Sync Trig Line

 Description:   Selects the TTL TRG line to be
                used in the Synchronous Trigger
                Protocol.  The SYNC message
                enables the SYNCHRONOUS TTLRG
                trigger protocol

 Variable Type: Integer

 Valid Range:   0 - Line 0
                1 - Line 1
                2 - Line 2
                3 - Line 3
                4 - Line 4
                5 - Line 5
                6 - Line 6
                7 - Line 7
                9 - Protocol Disabled

 Default Value: 9 - Protocol Disabled    	     Control Name:  Async Trig Line

 Description:   Selects the TTL TRG line pair to
                be used in the Asynchroneous
                Trigger Protocol as follows:

                0: 0 & 1
                1: 2 & 3
                2: 4 & 5
                3: 6 & 7

 Variable Type: Integer

 Valid Range:   0 - Line pair 0 & 1
                1 - Line pair 2 & 3
                2 - Line pair 4 & 5
                3 - Line pair 6 & 7
                9 - Protocol Disabled

 Default Value: 9 - Protocol Disabled    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Sync Trig Line out of range
       -3   Async Trig Line out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized    * =           Sync Trig Line                    l =v          Async Trig Line                   }             Instrument ID                               Error Code                                	   =0 - 0 1 - 1 2 - 2 3 - 3 4 - 4 5 - 5 6 - 6 7 - 7 Disabled - 9              50 & 1 - 0 2 & 3 - 1 4 & 5 - 2 6 & 7 - 3 Disabled - 9    1    	                Panel Name:    Special Functions

 Description:   This function selects the special
                function from the special
                functions which this driver
                supports.

                Call the Terminate all specials
                function to terminate all active
                special special functions.

                Functions supported by this driver
                are:

Read Relative Frequency:
                When this function is activated,
                the counter assigns a negative
                value to the last frequency
                reading and enters it into the
                frequency offset register
                (overwriting any existing
                frequency offset value). The last
                input frequency in this case means
                the actual frequency of the input
                signal, not including the effects
                of a frequency multiplier or other
                special function. The counter
                outputs the the relationship, i.e.
                the difference, between the last
                input frequency and the current
                one, subject to any other
                functions activated. It continues
                to do so until the function is
                terminated.

Display IF Readings:
                When this function is activated,
                the counter assigns a negative
                value to the local oscillator (LO)
                frequency and enters it into the
                frequency offset register
                (overwriting any existing
                frequency offset value). The
                counter then subtracts the LO
                frequency from the input frequency
                and outputs the resulting IF. It
                continues to do so until the
                function is terminated.

100 MHz Self-Test
                When this function is activated,
                the counter will count its
                internal VCO.  This function is
                use to verify that the  count
                chain, gate generator, and the VCO
                are operational.    M     Control Name:  Select Special

 Description:   Selects or terminates the Special
                functions. Functions which are
                supported are:

                100 MHz Self-Test: When this
                function is activated, the counter
                counts an internally generated
                test signal.  The counter returns
                a frequency reading of 100 MHz to
                indicate it passed Self-Test.

                Read Relative Frequency: When this
                function is activated, the counter
                assigns a negative value to the
                last frequency reading and enters
                it into the frequency offset
                register (overwriting any existing
                frequency offset value). The last
                input frequency in this case means
                the actual frequency of the input
                signal, not including the effects
                of a frequency multiplier or other
                special function. The counter
                outputs the the relationship, i.e.
                the difference, between the last
                input frequency and the current
                one,subject to any other functions
                activated. It continues to do so
                until the function is terminated.

                Display IF Readings:
                When this function is activated,
                the counter assigns a negative
                value to the local oscillator (LO)
                frequency and enters it into the
                frequency offset register
                (overwriting any existing
                frequency offset value). The
                counter then subtracts the LO
                frequency from the input frequency
                and outputs the resulting IF. It
                continues to do so until the
                function is terminated.

 Variable Type: Integer

 Valid Range:   0 - 100 MHz Self-Test
                1 - Read Relative Frequency
                2 - Display IF Readings

 Default Value: 0 - 100 MHz Self-Test          Control Name:  Returned Reading

 Description:   Outputs the Self-Test, Relative
                or IF frequency.

 Variable type: Double    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Select Special out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response    s =           Select Special                     =+         Returned Reading                  \             Instrument ID                     Ӥ          Error Code                                    (Self Test 0 Relative Frq 1 Display IF 2    	           1    	                 Panel Name:    Terminate All Specials

 Description:   This Function terminates all
                previously implemented special
                functions.    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    K     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized    "             Instrument ID                     j          Error Code                         1    	                Panel Name:    Hold Function

 Description:   This function selects the status
                of the Hold command.

                When Hold is On, the counter takes
                one reading and waits for a Reset
                or Trigger command.  Upon receipt
                of one of these commands, the
                counter will perform another
                measurement and, when requested,
                output the new reading over the
                VXI bus.  Note that a measurement
                result will be output only once;
                thus, when the instrument is in
                Hold, the user must trigger the
                counter before requesting another
                reading.  If no signal is found,
                the counter will output a zero.

                When the Hold command is Off, data
                is read out to the bus in the
                normal way.  The reading is
                automatically updated according to
                the specified sample rate, and the
                counter can output successive
                readings without requiring a Reset
                or Trigger command each time.          Control Name:  Hold

 Description:   Holds the last result if On.
                Hold On puts the counter into
                triggered operational mode.

 Variable Type: Integer

 Valid Range:   1 - On
                0 - Off

 Default Value: 0 - Off    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    i     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Hold out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized     =           Hold                                           Instrument ID                     3          Error Code                         On 1 Off 0    1    	                Panel Name:    Set Measurement Type

 Description:   This function selects which type
                of measurement will be output
                by the instrument when the Get
                Measurement function is used:
                Frequency, Width, or Period.
                Also, use Set Measurement Type
                before using the trigger
                if a triggered mode is selected.          Control Name:  Measurement

 Descriptor:    This parameter controls the
                measurement to output.

 Variable Type: Integer

 Valid Range:   0 - Frequency
                1 - Width
                2 - Period

 Default Value: 0 - Frequency
    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    K     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Measurement Type out of range

      230   Error writing to instrument
      232   Instrument not initialized     =          Measurement Type                  	             Instrument ID                     Q          Error Code                                    #Frequency - 0 Width - 1 Period - 2    1    	           d     Panel Name:    Trigger Function

 Description:   This function selects and
                implements one of the two internal
                trigger functions, trigger or
                reset.

                Trigger triggers a new
                measurement cycle. If a
                measurement cycle is in progress
                it will be aborted.

                Reset resets
                the converter and restarts the
                measurement process. If a
                measurement is found, a
                measurement will be taken, even if
                the counter is in Hold.    C     Control Name:  Function

 Description:
                1. Reset: Resets the converter and
                   restarts the signal acquisition
                   process.  If a signal is found,
                   a measurement will be taken,
                   even if the counter is in Hold.

                2. Trigger: Triggers a new
                   measurement cycle, If a
                   measurement cycle is in
                   progress, it will be aborted.

 Variable Type: Integer

 Valid Range:   1 - Trigger
                0 - Reset

 Default Value: 0 - Reset    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    C     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Function out of range

      230   Error writing to instrument
      232   Instrument not initialized     =           Function                          =             Instrument ID                               Error Code                         Trigger 1 Reset 0    1    	           y     Panel Name:    Get Measurement

 Description:   This function reads the
                measurement back from the
                instrument. All measurement
                configuration and triggering must
                be implemented before this
                function is called to insure
                accurate data is returned from the
                instrument.    H     Control Name:  Result

 Description:   Outputs the measurement result,
                all measurement configuration and
                triggering must be implemented
                before this function is called to
                insure accurate data is returned
                from the instrument.

 Variable Type: Real    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    V     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range

      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response     =          Measurement                       f             Instrument ID                               Error Code                         	           1    	                Panel Name:    Save/Recall Instr Setup

 Description:   This function selects and
                implements the Store and Recall
                functions. The Store command
                causes the instrument to save it's
                current setup in one of its 10
                internal storage registers (0-9).
                After power-up or initialization,
                the instrument restores itself
                from register 0.
          Control Name:  Setup Register

 Description:   Specifies which instrument
                storage register is to be
                stored or recalled.

 Variable Type: Integer

 Valid Range:   0 through 9

 Default Value: 0         Control Name:  Mode

 Description:   This function causes the counter's
                setup to be stored into or
                recalled from one of its
                10 internal storage registers.
                Register 0 is the instrument's
                default register.  At turn-on
                the instrument will be configured
                per setup data from register 0.

        Store:  Saves the current counter setup
                in the storage register specified
                in the register box.

        Recall: Recalls a counter setup which
                has been previously stored
                in the specified storage register.

 Variable Type: Integer

 Valid Range:   1 - Store
                0 - Recall

 Default Value: 0 - Recall    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    g     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Mode out of range
       -3   Setup Register out of range

      230   Error writing to instrument
      232   Instrument not initialized     =           Setup Register                     =+          Mode                                          Instrument ID                              Error Code                         0    Store 1 Recall 0    1    	                Panel Name:    Save Default Setup

 Description:   The counter's setup is recalled
                from Save/Recall register 0 at
                power-up or upon receipt of the
                the initialize command. The
                register can be changed by the
                user in order to alter the
                instrument's default settings.
                This function restores register
                0 to the instrument's factory
                default settings.
    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    g     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Mode out of range
       -3   Setup Register out of range

      230   Error writing to instrument
      232   Instrument not initialized   	>             Instrument ID                              Error Code                         1    	           
     Panel Name:    Get General Setup Info:

 Description:   This panel returns the current
                value of the parameter selected.
                Parameter definitions are below.

 Average Val:   This parameter controls the number
                of measurements to be averaged on
                frequency and pulse parameters.

 Band:          This parameter controls the
                frequency measurement range for
                the EIP1230A/1231A models.
                Select a specific band according
                to the following table.

                0: 100 Hz - 250 MHz (CW only)
                1: 250 MHz - 1 GHz
                2: 950 MHz - 26.5 GHz (EIP1230A)
                   950 MHz - 20 GHz (EIP1231A)
                3: 26.5 GHz - 170 GHz (Optional)

 Sub Band:      This parameter controls the
                frequency measurement range of
                Band 3 and is set according to the
                remote sensor being used.  Select
                the apprpriate sybband according
                to the following table.

                1:  26.5 GHz to 40 GHz
                2:  33 GHz to 50 GHz
                3:  40 GHz to 60 GHz
                4:  50 GHz to 75 GHz
                5:  60 GHz to 90 GHz
                6:  75 GHz to 110 GHz
                7:  90 GHz to 140 GHz
                8:  110 GHz to 170 GHz

 Center Freq:   This parameter controls the center
                frequency mode of operation in
                which the counter looks for a
                signal in the vicinity of the
                center frequency value.  This mode
                can be uded to reduce acquisiton
                time or when measuring a
                particylar signal in a multiple
                signal environment.  This mode is
                available in either Band 2 or Band
                3.  The value is returned in Hz.

 Resolution:    This parameter controls the
                frequency measurement resolution.
                Select the desired resolution
                according ro the following table:

                2: 100 Hz
                3: 1 kHz
                4: 10 kHz
                5: 100 kHz
                6: 1 MHz
                7: 10 MHz
                8: 100 MHz
                9: 1 GHz

 Low/high limit:This parameter controls the lo/hi
                end of the frequency window that
                is searched for a signal in Band
                2.  Select Low Limit in the
                range of 900 MHz to 26700 MHz for
                Model 1230A and in the range of
                900 MHz to 20500 MHz for Model
                1231A.  The values are returned in
                Hz.

 Synch Line:    Selects the TTL TRG line to be
                used in the Synchronous Trigger
                Protocol.  The SYNC message
                enables the SYNCHRONOUS TTLRG
                trigger protocol

 Asynch Line:   Selects the TTL TRG line pair to
                be used in the Asynchroneous
                Trigger Protocol as follows:

                0: 0 & 1
                1: 2 & 3
                2: 4 & 5
                3: 6 & 7

 Inhibit Line:  Selects the input to be used for
                the measurement inhibit function
                as follows:

                0: VXIbus ECLTRG0 line
                1: VXIbus ECLTRG1 line
                2: Front Panel

 MinPRF:        This parameter controls the
                minimum pulse repetition frequency
                of the pulsed signals that can be
                acquired and measured by the
                counter.  For example, if 500 Hz
                is selected, the counter will
                measure signals with a pulse
                repetition frequency of 500 Hz or
                greater.  The value is returned in
                Hz.

 Multiplier:    This parameter controls the value
                of the constant M in the formula:

                Output Frequency = (M * measured
                frequency) + B

                Where M is the frequency
                multiplier and B is the frequency
                offset.

 Offset:        Allows the entry of a positive or
                negative frequency to 1 kHz
                resolution into the offset
                frequency register.  This
                parameter controls the constant B
                in the formula:

                Output Frequency = (M * measured
                frequency) + B

                Where M is the frequency
                multiplier and B is the frequency
                offset.    A     Control Name:  Setup

 Description:   Selects the Setup Parameter to be
                viewed, returns the current
                setting of the selected parameter

 Variable Type: Integer

 Valid Range:   0 - Avg Value
                1 - Band
                2 - Subband
                3 - Center Freq
                4 - Resolution
                5 - Low Limit
                6 - High Limit
                7 - Async Line
                9 - Sync Line
               10 - MIN PRF
               11 - Multiplier
               12 - Offset

 Default Value: 12 - Offset         Control Name:  Display

 Description:   This function displays the current
                status of the parameter selected.
                Parameter definitions are below.

 Average Val:   This parameter controls the number
                of measurements to be averaged on
                frequency and pulse parameters.

 Band:          This parameter controls the
                frequency measurement range for
                the EIP1230A/1231A models.
                Select a specific band according
                to the following table.

                0: 100 Hz - 250 MHz (CW only)
                1: 250 MHz - 1 GHz
                2: 950 MHz - 26.5 GHz (EIP1230A)
                   950 MHz - 20 GHz (EIP1231A)
                3: 26.5 GHz - 170 GHz (Optional)

 Sub Band:      This parameter controls the
                frequency measurement range of
                Band 3 and is set according to the
                remote sensor being used.  Select
                the apprpriate sybband according
                to the following table.

                1:  26.5 GHz to 40 GHz
                2:  33 GHz to 50 GHz
                3:  40 GHz to 60 GHz
                4:  50 GHz to 75 GHz
                5:  60 GHz to 90 GHz
                6:  75 GHz to 110 GHz
                7:  90 GHz to 140 GHz
                8:  110 GHz to 170 GHz

 Center Freq:   This parameter controls the center
                frequency mode of operation in
                which the counter looks for a
                signal in the vicinity of the
                center frequency value.  This mode
                can be uded to reduce acquisiton
                time or when measuring a
                particylar signal in a multiple
                signal environment.  This mode is
                available in either Band 2 or Band
                3.  The value is returned in Hz.

 Resolution:    This parameter controls the
                frequency measurement resolution.
                Select the desired resolution
                according ro the following table:

                2: 100 Hz
                3: 1 kHz
                4: 10 kHz
                5: 100 kHz
                6: 1 MHz
                7: 10 MHz
                8: 100 MHz
                9: 1 GHz

 Low/high limit:This parameter controls the lo/hi
                end of the frequency window that
                is searched for a signal in Band
                2.  Select Low Limit in the
                range of 900 MHz to 26700 MHz for
                Model 1230A and in the range of
                900 MHz to 20500 MHz for Model
                1231A.  The values are returned in
                Hz.

 Synch Line:    Selects the TTL TRG line to be
                used in the Synchronous Trigger
                Protocol.  The SYNC message
                enables the SYNCHRONOUS TTLRG
                trigger protocol

 Asynch Line:   Selects the TTL TRG line pair to
                be used in the Asynchroneous
                Trigger Protocol as follows:

                0: 0 & 1
                1: 2 & 3
                2: 4 & 5
                3: 6 & 7

 Inhibit Line:  Selects the input to be used for
                the measurement inhibit function
                as follows:

                0: VXIbus ECLTRG0 line
                1: VXIbus ECLTRG1 line
                2: Front Panel

 MinPRF:        This parameter controls the
                minimum pulse repetition frequency
                of the pulsed signals that can be
                acquired and measured by the
                counter.  For example, if 500 Hz
                is selected, the counter will
                measure signals with a pulse
                repetition frequency of 500 Hz or
                greater.  The value is returned in
                Hz.

 Multiplier:    This parameter controls the value
                of the constant M in the formula:

                Output Frequency = (M * measured
                frequency) + B

                Where M is the frequency
                multiplier and B is the frequency
                offset.

 Offset:        Allows the entry of a positive or
                negative frequency to 1 kHz
                resolution into the offset
                frequency register.  This
                parameter controls the constant B
                in the formula:

                Output Frequency = (M * measured
                frequency) + B

                Where M is the frequency
                multiplier and B is the frequency
                offset.    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range
       -2   Setup out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response    -           Setup                            ! -9         Display                          3             Instrument ID                    6          Error Code                                
   Average Val- 0 Band - 1 Subband - 2 Center Freq- 3 Resolution - 4 Low Limit - 5 High Limit - 6 Asynch Line- 7 Synch Line - 8 Inhibit Line 9 MinPRF - 10 Multiplier - 11 Offset - 12    	            1    	                 Panel Name:    Write To Instrument

 Description:   Writes commands and queries to the
                instrument to modify parameters
                and query device settings.    R     Control Name:  Write Buffer

 Description:   The user can use this control to
                send common commands and queries
                to the instrument. This control
                can also be used to write any
                valid command to the instrument.

 Variable Type: String

 Default Value: "*RST"

 NOTES: (1) The command or query to be sent to the
            instrument may be a literal enclosed
            in double quotes i.e. "*RST" or may be
            contained in a variable of type
            string.

        (2) If the number of bytes to be written
            is greater than the size of "cmd" in
            the source code then the size of cmd
            must be increased. The original size
            of cmd is 50 bytes (cmd[50]) the
            largest cmd may be declared as is
            32,767 bytes.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error Code
 Description:   Displays the results of the
                function call.
 Variable Type: Integer
 Error Codes:
        0   Success
       -1   Instrument ID out of range
      230   Error writing to instrument
      232   Instrument not initialized   :/ -          Write Buffer                     =             Instrument ID                    ?          Error Code                         "RE"    1    	                Panel Name:    Read Instrument Data

 Description:   Reads data from instrument buffer
                and returns it to the specified
                variable in memory.

 NOTES: (1) Because the instrument may return both
            numeric and text data in response to
            queries this function returns the data
            in string format.

        (2) If valid data is not available at the
            instrument's output buffer when this
            function is called the instrument will
            hang up and the function will not
            return until it times out.  If the
            time-out is disabled this function
            will hang indefinitely and it may be
            neccessary to reboot the computer to
            break out.         Control Name:  Number of Bytes to Read

 Description:   The number of bytes specified by
                this control should be greater
                than or equal to the number of
                bytes which are to be read from
                the instrument. If the actual
                number of bytes to be read is
                greater than the number this
                control specifies then multiple
                reads will be necessary to empty
                the instrument's output buffer.

                If the instrument's output buffer
                is not emptied the instrument may
                return invalid data when future
                reads are performed.

 Variable Type: Integer

 Default Value: 50 (See NOTE 2)

 NOTES: (1) If NO DATA is available at the
            instrument's output buffer when this
            function is called the instrument will
            hang up and the function will not
            return until it times out.  If the
            time-out is disabled, this function
            will hang indefinitely and it may be
            neccessary to reboot the computer.

        (2) If the number of bytes expected is
            greater than 50 the value of this
            control may be increased. If the
            actual number of bytes read is larger
            than the declared size of the read
            buffer a run-time error will be
            generated.         Control Name:  Read Buffer

 Description:   The incoming data from the
                instrument is placed into this
                variable.

 Variable Type: String

 NOTES: (1) Because the Instrument may return both
            numeric and text data in response to
            queries this function returns the data
            in string form.

        (2) This function does not overwrite any
            old data left in the string variable
            from the last time the function was
            called. String data in LabWindows is
            terminated with an ASCII null(Hex 0)
            and string manipulation functions will
            only recognize data before the ASCII
            null.

        (3) The declared size of the string
            variable must be greater than the
            actual number of bytes read from the
            instrument if it is not a run-time
            error will be generated.         Control Name:  Number of Bytes Read

 Description:   This variable contains the actual
                number of bytes read from the
                instrument. This is the value
                which is returned by the read
                function. The global variable
                "ibcnt" holds the result of GPIB
                reads and the global variable
                "bytes" holds the result of VXI
                word serial reads.

 Variable Type: Long

 NOTE: If the actual number of bytes read is less
       than the number of bytes specified in
       number of bytes to read then the output
       buffer is probably empty. If the number of
       bytes read is 0 and the instrument returns
       a 231 error code the read function failed.
       The most probable cause for the read to
       fail is because there was no data available
       at the instrument's output buffer.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    y     Control Name:  Error Code
 Description:   Displays status relating to the
                function call.
 Variable Type: Integer

 Error Codes:
        0   Success
       -1   Instrument ID out of range
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response   D ] 6          Number Bytes To Read             Jr M          Read Buffer                      N# M         NumBytes Read                    Q             Instrument ID                    T          Error Code                         50    	            	            1    	            r     Panel Name:    Reset

 Description:   This function resets the
                instrument to its default state.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    y     Control Name:  Error Code
 Description:   Displays status relating to the
                function call.
 Variable Type: Integer

 Error Codes:
        0   Success
       -1   Instrument ID out of range
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response   WH             Instrument ID                    Y          Error Code                         1    	                 Panel Name:    Error Clear/Query

 Description:   Either clears pending error
                indications or reads the
                current error number. An error
                number of 0 means that there
                are no errors.
    G     Control Name:  Action

 Description:   This switch determines the action
                performed by the function.

 Variable Type: Integer

 Valid Range:   0 - Read last 123x error
                1 - Cause the 123x to clear
                    its internal error
                    indications.

 Default Value: 0 - Read          Control Name:  Error Code

 Description:   This output returns the error code
                read from the instrument error
                queue.

 Variable Type: Integer *          Control Name:  Error Message

 Description:   This output returns the error
                message string read from the
                instrument's error message queue.

 Variable Type: String (char *)    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    y     Control Name:  Error Code
 Description:   Displays status relating to the
                function call.
 Variable Type: Integer

 Error Codes:
        0   Success
       -1   Instrument ID out of range
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response   \ M /          Action                           ] M           123x Error Number                ^ M         Error Message                    _             Instrument ID                    a          Error Code                         Clear Error 1 Read Error 0    	            	            1    	           {     Panel Name:    Revision Query

 Description:   This function returns the revision
                numbers of the instrument driver
                and instrument firmware, and tells
                the user what firmware the driver
                is compatible with, i.e., Driver
                Revision "A1.0" is compatible
                with Firmware Revision(s) "3.00".          Control Name:  Driver Revision

 Description:   This control returns the
                Instrument Driver Revision.

 Variable Type: String (char *)          Control Name:  Firmware Revision

 Description:   This control returns the
                Instrument's Firmware
                Revision.

 Variable Type: String (char *)    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    y     Control Name:  Error Code
 Description:   Displays status relating to the
                function call.
 Variable Type: Integer

 Error Codes:
        0   Success
       -1   Instrument ID out of range
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response   f3 = g         Driver Revision                  f =2         Firmware Revision                g             Instrument ID                    i          Error Code                         	            	            1    	                 Panel Name:     Close

 Description:    The close routine removes the
                 entry for the instrument from the
                 Instrument Table.

 Note: The instrument must be reinitialized to use
       it again.    @     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error Code

 Description:   Displays status relating to the
                function call.
 Variable Type: Integer
 Error Codes:
        0   Success

       -1   Instrument ID out of range

      221   Unable to close device
      232   Device not initialized   mR             Instrument ID                    o          Error Code                         1    	                  '  9     K.    init                                     ;u  G     K.    band_eip1230                             L  S 	    K.    band_eip1231                             U  d     K.    center_freq                              e  rh     K.    freq_win_lim                             s]  z     K.    sample_rate                              z  g     K.    resolution                               }       K.    freq_avr                                 n       K.    freq_offset                                >     K.    min_freq_rep                             X        K.    inhibit_input                                   K.    time_base                                L  i     K.    trig_setup                                 R     K.    special_funct                            z  ڽ     K.    terminate_spec                           8       K.    hold_func                                b       K.    set_meas_type                                   K.    trigger_func                                    K.    get_measurement                           N     K.    counter_setup                           L      K.    save_default_setup                      
p 7     K.    get_gen_setup_info                      9s A     K.    write                                   A U     K.    read                                    V [)     K.    reset                                   [ c`     K.    error_query                             d kj     K.    revision_query                          lg p     K.    close                                                                       DInitialize                          Configuration                       MBands (1230 & 1231)                  DBands for EIP1230 A                  DBand for EIP1231 A                   DCenter Frequency                     DFrequency Window Limits              DSample Rate                          DResolution                           DFrequency Average                    DFrequency Offset                     DMin Pulse Repetition                 DInhibit Input                        DTime Base Source                     DTrigger Set Up                      bSpecial Functions                    DSpecial Function Select              DTerminate All Specials              Measurement                          DHold Function                        DSet Measurement Type                 DTrigger Function                     DGet Measurement                      Save/Recall Instr Setup              DSave/Recall Instr Setup              DSave Default Setup                   DGet General Setup Info              #Low Level                            DWrite to instrument                  DRead Instrument Data                 DReset instrument                     DError Clear/Query                    DRevision Query                       DClose                           